//L Bracket
 $fn=90; //makes cylinders look smoother when rendered
 in2mm=25.4; //conversion from inches to millimeters
 
 //dimensions of bracket. Number is in inches and is then converted to mm
 side1=0.5*in2mm; //length of side along x axis
 side2=1*in2mm; //length of side along y axis
 width=0.5*in2mm; //width of bracket along z axis
 thickness=0.1*in2mm; //thickness of bracket
 holediameter=0.125*in2mm + 0.35; //diameter of hole, extra amount was needed by my printer so that hole was desired size
 
 extra=0.1; //extra amount so that cuts don't leave stuff behind

 difference(){
   translate([-side1/2,-side2/2,0]){ //L bracket should surround origin
     difference(){ //subtract one rectangular solid from another to leave the L bracket, then subtract the two cylinders to leave the holes
       cube([side1,side2,width]); //Initial rectangular solid
       translate([thickness, thickness, -extra]){ //translate another rectangular solid by the desired thickness and remove it
         cube([side1,side2,width+2*extra]); //same size as original solid except a little extra to make a cleaner cut
       }
     }
   }
   //start with a cylinder along the z (up) axis, then turn it 90 degrees around the x axis so that it can make the hole in side1 of the bracket
   translate([0,-side2/2+thickness/2,width/2]){ //translate to middle of side to be drilled
     rotate([90,0,0]){//rotate 90 degrees around the x axis
       translate([0,0,-thickness/2-extra]){//shift so that center of the cylinder is at z=0
         cylinder(d=holediameter, h = thickness+2*extra);//cylinder which will become the hole
       }
     }
   }
   //start with a cylinder along the z (up) axis, then turn it 90 degrees around the y axis so that it can make the hole in side2 of the bracket
   translate([-side1/2+thickness/2,0,width/2]){ //translate to middle of side to be drilled
     rotate([0,90,0]){//rotate 90 degrees around the y axis
       translate([0,0,-thickness/2-extra]){//shift so that center of the cylinder is at z=0
         cylinder(d=holediameter, h = thickness+2*extra); //cylinder which will become the hole
       }
     }
   }
 }